function int_table = WcdmaFirstInterleaver(numBits, tti);
% Performs block interleaver with inter-column permutations  
% as specified by 3GPP TS 25.212.

% Inter-column permutation patterns for 1st Interleaving
seq10 = [0];
seq20 = [0 1];
seq40 = [0 2 1 3];
seq80 = [0 4 2 6 1 5 3 7];

switch (tti)
case 10
    perm = seq10+1;
case 20
    perm = seq20+1;
case 40
    perm = seq40+1;
case 80
    perm = seq80+1;
end

% Compute Number of Columns C1
nCols = tti/10;

% Compute Number of Rows R1
nRows = numBits/nCols;

% Write the input bit sequence into R1xC1 matrix row-by-row
inputSeq = [1:numBits];
inMatrix = reshape(inputSeq', nCols, nRows)';

% Perform inter-column permutation based on the above pattern  
outMatrix = inMatrix(:,perm);

% Read the bit sequence of the block interleaver column-by-column
int_table = reshape(outMatrix, 1, nRows*nCols)';



